
cap program drop donow
program define donow
use if age<=65 using "${dir3}mergedCF1_noPA", clear
compress

bysort id: egen tot=count(year)
keep if tot!=. & tot!=1
drop tot

bysort CF1 c_b year: egen pippo=count(year)
bysort CF1 c_b: egen fr_c_new=median(pippo)
keep if fr_c_new<=30
drop pippo 


rename c_bth_i codice_comune_istat_num103

merge m:1 codice_comune_istat_num103 using "${dir1}DEMO_cat.dta",keep(master matched) keepusing(c_rev_tot_avg c_rev_transf_avg c_exp_tot_avg c_exp_discr_avg c_rev_tot_avg_pp* c_rev_transf_avg_pp* c_exp_tot_avg_pp* c_exp_discr_avg_pp* c_pop c_elderly_index c_income_pc c_family_size c_prov_capital c_reg_capital c_turnout c_delitti c_delitti_pa c_delitti_corr c_ur c_active_pop c_tot_pols_c p_magistr p_effectmagistr p_donation p_ur c_pct_laureati c_pct_pub_giur c_pct_pub_sect c_mafia c_to c_sd c_tot_polsa_c c_tot_polsb_c c_tot_polsa_c_cou c_tot_polsb_c_cou c_tot_polsa_c_exe c_tot_polsb_c_exe c_value_works c_value_serv c_value_proj c_value_health c_value_tot c_n_firms_pc c_exp_speed_avg c_noprof_ass c_noprof_empl c_comando_cc c_ncomandi_cc c_comando_gdf c_ncomandi_gdf  c_comando_ps c_ncomandi_ps c_mean_rix)

rename  codice_comune_istat_num103 c_bth_i
drop f_*  sur* cf CF1 cod* dist

drop _m

	gen c_lrev_pp=ln(c_rev_tot_avg_pp)
	gen c_lexp_pp=ln(c_exp_tot_avg_pp)
	gen c_lrev=ln(c_rev_tot_avg)
	gen c_ltra=ln(c_rev_transf_avg)
	gen c_lexp=ln(c_exp_tot_avg)
	gen c_ldis=ln(c_exp_discr_avg)
	gen c_ltra_pp=ln(c_rev_transf_avg_pp)
	gen c_ldis_pp=ln(c_exp_discr_avg_pp)
	rename c_rev_tot_avg c_rev
	rename c_rev_transf_avg c_tra
	rename c_exp_tot_avg c_exp
	rename c_exp_discr_avg c_dis
	rename c_rev_tot_avg_pp c_rev_pp
	rename c_rev_transf_avg_pp c_tra_pp
	rename c_exp_tot_avg_pp c_exp_pp
	rename c_exp_discr_avg_pp c_dis_pp
    gen c_rev_pc=c_rev/c_pop
    gen c_lrev_pc=ln(c_rev/c_pop)
    gen c_exp_pc=c_exp/c_pop
    gen c_lexp_pc=ln(c_exp/c_pop)
    gen c_dis_pc=c_dis/c_pop
    gen c_ldis_pc=ln(c_dis/c_pop)
	rename p_donation p_don
	replace p_don=p_don*100
	egen p_pop=sum(c_pop), by(p_b)
    gen c_proc_pc=c_value_tot/c_pop
	gen c_lproc_pc=ln(c_value_tot/c_pop)
	rename c_exp_speed_avg c_exp_speed
    gen c_noprof_ass_pc=c_noprof_ass/c_pop*1000
    gen c_lnoprof_ass_pc=ln(c_noprof_ass/c_pop*1000)
	gen c_noprof_empl_pc=c_noprof_empl/c_pop*1000
	replace c_noprof_empl=0.01 if c_noprof_empl==0
	gen c_lnoprof_empl_pc=ln(c_noprof_empl/c_pop*1000)
	gen c_ncomandi_cc_pc=c_ncomandi_cc/c_pop*1000
	replace c_ncomandi_cc=0.01 if c_ncomandi_cc==0
	gen c_lncomandi_cc_pc=ln(c_ncomandi_cc/c_pop*1000)
	gen c_ncomandi_gdf_pc=c_ncomandi_gdf/c_pop*1000
	replace c_ncomandi_gdf=0.01 if c_ncomandi_gdf==0
	gen c_lncomandi_gdf_pc=ln(c_ncomandi_gdf/c_pop*1000)
	gen c_ncomandi_ps_pc=c_ncomandi_ps/c_pop*1000
	replace c_ncomandi_ps=0.01 if c_ncomandi_ps==0
	gen c_lncomandi_ps_pc=ln(c_ncomandi_ps/c_pop*1000)

    gen p_mag_pc=p_magistr/p_pop
	gen p_lmag_pc=ln(p_magistr/p_pop)
	gen p_lmag=ln(p_magistr)
	rename p_magistr p_mag
	gen p_emag_pc=p_effectmagistr/p_pop
	gen p_lemag_pc=ln(p_effectmagistr/p_pop)
	gen p_lemag=ln(p_effectmagistr)
	rename p_effectmagistr p_emag
	gen c_linc=ln(c_income_pc)
	rename c_income_pc c_inc
	gen c_lfsize=ln(c_family_size)
	rename c_family_size c_fsize
	rename c_prov_capital c_pcap
	rename c_reg_capital c_rcap
	rename c_turnout c_tur 
	gen c_del_pc=c_delitti/c_pop
	gen c_ldel_pc=ln(c_delitti/c_pop)
	gen c_ldel=ln(c_delitti)
	rename c_delitti c_del
	gen c_delpa_pc=c_delitti_pa/c_pop
	replace c_delitti_pa=0.1 if c_delitti_pa==0
	gen c_ldelpa_pc=ln(c_delitti_pa/c_pop)
	gen c_ldelpa=ln(c_delitti_pa)
	rename c_delitti_pa c_delpa 
	replace c_delpa=0 if c_delpa==0.1
	gen c_delcorr_pc=c_delitti_corr/c_pop*1000
	replace c_delitti_corr=0.1 if c_delitti_corr==0
	gen c_ldelcorr_pc=ln(c_delitti_corr/c_pop)
	gen c_ldelcorr=ln(c_delitti_corr)
	rename c_delitti_corr c_delcorr
	replace c_delcorr=0 if c_delcorr==0.1
	rename c_elderly c_old
	replace c_old=. if c_old==0
	gen c_lpop=ln(c_pop)
	gen c_ltpols=ln(c_tot_pols_c)
	rename c_tot_pols_c c_tpols
    g c_ltpols_pc=c_ltpols-c_lpop
	gen c_ltpolsa=ln(c_tot_polsa_c)
	rename c_tot_polsa_c c_tpolsa
    g c_ltpolsa_pc=c_ltpolsa-c_lpop
	gen c_ltpolsb=ln(c_tot_polsb_c)
	rename c_tot_polsb_c c_tpolsb
    g c_ltpolsb_pc=c_ltpolsb-c_lpop
	gen c_ltpolsa_cou=ln(c_tot_polsa_c_cou)
	rename c_tot_polsa_c_cou c_tpolsa_cou
    g c_ltpolsa_cou_pc=c_ltpolsa_cou-c_lpop
	gen c_ltpolsb_cou=ln(c_tot_polsb_c_cou)
	rename c_tot_polsb_c_cou c_tpolsb_cou
    g c_ltpolsb_cou_pc=c_ltpolsb_cou-c_lpop
	gen c_ltpolsa_exe=ln(c_tot_polsa_c_exe)
	rename c_tot_polsa_c_exe c_tpolsa_exe
    g c_ltpolsa_exe_pc=c_ltpolsa_exe-c_lpop
	gen c_ltpolsb_exe=ln(c_tot_polsb_c_exe)
	rename c_tot_polsb_c_exe c_tpolsb_exe
    g c_ltpolsb_exe_pc=c_ltpolsb_exe-c_lpop
    replace c_delpa_pc=c_delpa_pc*1000
	g c_ln_firms_pc=log(c_n_firms_pc)
	g c_lmean_rix=ln(c_mean_rix)

gen area5=1 if r_b>=1 & r_b<=3 | r_b==7
replace area5=2 if r_b>=4 &  r_b<=6 | r_b==8
replace area5=3 if r_b>=9 & r_b<=12
replace area5=4 if r_b>=13 & r_b<=18
replace area5=5 if r_b>18 & r_b<.

g area3=1 if area5==1 | area5==2
replace area3=2 if area5==3
replace area3=3 if area5>3 & area5<.
label define r_b 1 "PIE" 2 "VDA" 3 "LOM" 4 "TRE" 5 "VEN" 6 "FRI" 7 "LIG" 8 "EMI" 9 "TOS" 10 "UMB" 11 "MAR" 12 "LAZ" 13 "ABR" 14 "MOL" 15 "CAM" 16 "PUG" 17 "BAS" 18 "CAL" 19 "SIC" 20 "SAR"
label define area5 1 "NE" 2"NW" 3 "CENTRE" 5 "ISLANDS" 4 "SOUTH"
label define area3 1 "NORTH" 2 "CENTRE" 3  "SOUTH"
for any r_b area5 area3: label values X X

cap drop miss*
 
label var c_lrev "Revenues (log)"
label var c_lexp "Expenditure (log)"
label var c_ldis "Discretionary exp. (log)"
label var c_lrev_pp "Revenues per politician (log)"
label var c_lrev_pc "Revenues per capita (log)"
label var c_lexp_pp "Expenditure per politician (log)"
label var c_lexp_pc "Expenditure per capita (log)"
label var c_ldis_pp "Discretionary exp. per politician (log)"
label var c_ldis_pc "Discretionary exp. per capita (log)"
label var c_ltpols "Politicians (log)"
label var c_ltpols_pc "Politicians per capita (log)"
label var c_ldelpa "Crimes against Public Administration (log)"
label var c_ldelpa_pc "Crimes against PA per capita (log)"
label var c_delpa_pc "Crimes against PA per capita"
label var c_ldelcorr_pc "Corruption crimes per (1,000) capita (log)"
label var c_delcorr_pc "Corruption crimes per (1,000) capita"
label var c_linc "Income per capita (log)"
label var c_lpop "Population (log)"
label var c_ur "Pct. unemployment"
label var c_active_pop "Pct. active pop."
label var p_ur "Province unemployment"
label var c_tur "Pct. voters' turnout"
label var p_don "Pct. blood donors"
label var c_mafia "Municipality dissolved for Mafia"
label var c_pct_laureati "Pct. college"
label var c_pct_pub_giur "Pct. public sector employment"
label var c_pct_pub_sect "Pct. public sector employment"
label var c_rcap "Region capital"
label var c_pcap "Province capital"
label var p_lemag "Effective judges (log)"
label var p_lemag_pc "Effective judges per capita (log)"
label var p_emag_pc "Effective judges per capita"
label var c_to "Court"
label var c_sd "Subsidiary court"
label var c_ltpolsb_cou_pc "Cou. politicians per ca pita (log)"
label var c_ltpolsb_exe_pc "Exe. politicians per capita (log)"
label var c_fsize "Avg. household size"
label var c_old "Elderly index"
label var c_lproc_pc "Value of procurement per capita (log)
label var c_exp_speed "Speed of expenditure"
label var c_n_firms_pc "Firms per capita" 
label var c_ln_firms_pc "Firms per capita (log)" 
label var c_noprof_ass_pc "Non-profit organizations per (1,000) capita"
label var c_lnoprof_ass_pc "Non-profit organizations per (1,000) capita (log)"
label var c_noprof_empl_pc "Employees in non-profit organizations per (1,000) capita"
label var c_lnoprof_empl_pc "Employees in non-profit organizations per (1,000) capita (log)"
label var c_comando_cc "CC station"
label var c_ncomandi_cc "CC stations"
label var c_ncomandi_cc_pc "CC stations per (1,000) capita"
label var c_lncomandi_cc_pc "CC stations per (1,000) capita (log)"
label var c_comando_gdf "GDF station"
label var c_ncomandi_gdf "GDF stations"
label var c_ncomandi_gdf_pc "GDF stations per (1,000) capita"
label var c_lncomandi_gdf_pc "GDF stations per (1,000) capita (log)"
label var c_comando_ps "PS station"
label var c_ncomandi_ps "PS stations"
label var c_ncomandi_ps_pc "PS stations per (1,000) capita"
label var c_lncomandi_ps_pc "PS stations per (1,000) capita (log)"

preserve
global vars="c_linc c_ln_firms_pc c_ur c_pct_pub_sect c_pct_laureati c_old c_lpop c_rcap c_pcap c_comando_cc c_comando_ps c_comando_gdf c_to c_sd c_del_pc c_delcorr_pc c_mafia c_lnoprof_ass_pc c_tur c_ltpols_pc"
collapse $vars
statsmat $vars, stat(mean sd) listwise format(%20.3f) matrix(city_demo)
outtable using "${dir5}city_demo", replace nobox format( %20.3fc) label mat(city_demo)
restore

tab area3, g(darea3)
label var darea31 "North"
label var darea32 "Center"
label var darea33 "South"

global y1="tot_wg"
global y2="n_paid_m"
global y3="empl"
global geo="p_b"

keep $y1 $y2 $y3 $vars n_pols_ing n_pols_out c_ldis_pp c_b p_b id year aged

cap drop tmp
g tmp=1
global varsA="c_linc c_ln_firms_pc c_ur c_pct_pub_sect c_pct_laureati c_old c_lpop  c_del_pc c_delcorr_pc  c_lnoprof_ass_pc c_tur c_ltpols_pc"
global varsB="c_rcap c_pcap c_comando_cc c_comando_ps c_comando_gdf c_to c_sd c_mafia"
global vars1=""
global vars1_out=""
local group $varsA $varsB  
foreach c of local group {
cap drop a`c'
g a`c'=`c'*n_pols_ing
g b`c'=`c'*n_pols_out
drop `c'
global vars1="$vars1" + "a`c'"+" "
global vars1_out="$vars1_out" + "b`c'"+" "
}
end
donow

cap program drop regnow
program define regnow

reghdfe $y  c.$explain##c.$n_pols c.$explain#c.n_pols_out, absorb($others) vce(cluster c_b)
outreg2  using ${dir5}het_by_c_b, tex bdec(3) nocons $append ct($title) label 

reghdfe $y  c.$explain##c.$n_pols c.$explain#c.n_pols_out $vars1 $vars1_out, absorb($others) vce(cluster c_b)
outreg2  using ${dir5}het_by_c_b, tex bdec(3) nocons $append ct($title) label 

end
	
global n_pols="n_pols_ing"
global explain c_ldis_pp
global title ="discretionary exp per pol"

global type="Main"
global gr3="c_b"
global ct="+ controls & FE"
global others="id $geo#year aged"
global append="replace"
forvalues i=1(1)3 {
global y="${y`i'}"
regnow

}

